<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.php");
    exit();
}

$vehicle_id = $_GET['id'] ?? null;
if (!$vehicle_id) {
    die("No vehicle ID provided.");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $plate_number = $_POST['plate_number'];
    $make = $_POST['make'];
    $model = $_POST['model'];
    $mileage = (int)$_POST['mileage'];
    $last_service = $_POST['last_service'] ?: null;
    $service_due = $_POST['service_due'] ?: null;

    $stmt = $pdo->prepare("UPDATE vehicles SET plate_number = ?, make = ?, model = ?, mileage = ?, last_service = ?, service_due = ? WHERE id = ?");
    $stmt->execute([$plate_number, $make, $model, $mileage, $last_service, $service_due, $vehicle_id]);

    header("Location: vehicles.php");
    exit();
}

$stmt = $pdo->prepare("SELECT * FROM vehicles WHERE id = ?");
$stmt->execute([$vehicle_id]);
$vehicle = $stmt->fetch();

if (!$vehicle) {
    die("Vehicle not found.");
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Edit Vehicle</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
<h2>Edit Vehicle</h2>
<form method="post">
  <div class="mb-3">
    <label class="form-label">Plate Number</label>
    <input type="text" name="plate_number" class="form-control" value="<?= htmlspecialchars($vehicle['plate_number']) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Make</label>
    <input type="text" name="make" class="form-control" value="<?= htmlspecialchars($vehicle['make']) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Model</label>
    <input type="text" name="model" class="form-control" value="<?= htmlspecialchars($vehicle['model']) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Mileage</label>
    <input type="number" name="mileage" class="form-control" value="<?= $vehicle['mileage'] ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Last Service</label>
    <input type="date" name="last_service" class="form-control" value="<?= $vehicle['last_service'] ?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Next Service Due</label>
    <input type="date" name="service_due" class="form-control" value="<?= $vehicle['service_due'] ?>">
  </div>
  <button type="submit" class="btn btn-primary">Update Vehicle</button>
</form>
</body>
</html>
