<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$is_admin = $_SESSION['role'] === 'admin';

// Load checks
$query = "SELECT c.*, u.username, v.plate_number FROM checks c
          JOIN users u ON c.user_id = u.id
          JOIN vehicles v ON c.vehicle_id = v.id
          ORDER BY c.submitted_at DESC";
$checks = $pdo->query($query)->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Reports</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .tick { color: green; font-weight: bold; }
    .cross { color: red; font-weight: bold; }
  </style>
</head>
<body class="container py-4">
<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">Vehicle Check</a>
    <div class="collapse navbar-collapse">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link" href="dashboard.php">Dashboard</a></li>
        <li class="nav-item"><a class="nav-link" href="check.php">Submit Check</a></li>
        <li class="nav-item"><a class="nav-link" href="reports.php">Reports</a></li>
        <?php if ($is_admin): ?>
        <li class="nav-item"><a class="nav-link" href="vehicles.php">Manage Vehicles</a></li>
        <li class="nav-item"><a class="nav-link" href="service_history.php">Service History</a></li>
        <?php endif; ?>
        <li class="nav-item"><a class="nav-link" href="logout.php">Logout</a></li>
      </ul>
    </div>
  </div>
</nav>

<h2>Vehicle Check Reports</h2>
<table class="table table-bordered table-striped mt-3">
  <thead>
    <tr>
      <th>Date</th>
      <th>Driver</th>
      <th>Vehicle</th>
      <th>Mileage</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($checks as $check): ?>
    <tr>
      <td><?= date('d-m-Y', strtotime($check['submitted_at'])) ?></td>
      <td><?= htmlspecialchars($check['username']) ?></td>
      <td><?= htmlspecialchars($check['plate_number']) ?></td>
      <td><?= $check['mileage'] ?></td>
      <td>
        <a href="view_check.php?id=<?= $check['id'] ?>" class="btn btn-info btn-sm">View</a>
        <?php if ($is_admin): ?>
        <a href="edit_check.php?id=<?= $check['id'] ?>" class="btn btn-warning btn-sm">Edit</a>
        <a href="delete_check.php?id=<?= $check['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Delete this check?')">Delete</a>
        <?php endif; ?>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</body>
</html>
