<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: login.php');
    exit();
}

$vehicles = $pdo->query("SELECT * FROM vehicles ORDER BY plate_number")->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Manage Vehicles</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">Vehicle Check</a>
    <div class="collapse navbar-collapse">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link" href="dashboard.php">Dashboard</a></li>
        <li class="nav-item"><a class="nav-link" href="check.php">Submit Check</a></li>
        <li class="nav-item"><a class="nav-link" href="reports.php">Reports</a></li>
        <li class="nav-item"><a class="nav-link" href="vehicles.php">Manage Vehicles</a></li>
        <li class="nav-item"><a class="nav-link" href="service_history.php">Service History</a></li>
        <li class="nav-item"><a class="nav-link" href="logout.php">Logout</a></li>
      </ul>
    </div>
  </div>
</nav>

  <h2>Vehicle List</h2>
  <a href="add_vehicle.php" class="btn btn-success mb-3">Add Vehicle</a>
  <table class="table table-bordered table-striped">
    <thead>
      <tr>
        <th>Plate</th>
        <th>Make</th>
        <th>Model</th>
        <th>Mileage</th>
        <th>Last Service</th>
        <th>Next Service Due</th>
        <th>Actions</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($vehicles as $v): ?>
      <tr>
        <td><?= htmlspecialchars($v['plate_number']) ?></td>
        <td><?= htmlspecialchars($v['make']) ?></td>
        <td><?= htmlspecialchars($v['model']) ?></td>
        <td><?= $v['mileage'] ?></td>
        <td><?= isset($v['last_service']) && $v['last_service'] ? date('d-m-Y', strtotime($v['last_service'])) : 'N/A' ?></td>
        <td><?= isset($v['service_due']) && $v['service_due'] ? date('d-m-Y', strtotime($v['service_due'])) : 'N/A' ?></td>
        <td>
          <a href="edit_vehicle.php?id=<?= $v['id'] ?>" class="btn btn-warning btn-sm">Edit</a>
          <a href="delete_vehicle.php?id=<?= $v['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</a>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</body>
</html>
