<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: login.php');
    exit();
}

if (!isset($_GET['id'])) {
    echo "No check ID provided.";
    exit();
}

$check_id = $_GET['id'];
$stmt = $pdo->prepare("SELECT * FROM daily_checks WHERE id = ?");
$stmt->execute([$check_id]);
$check = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$check) {
    echo "Check not found.";
    exit();
}

$checklist = json_decode($check['checklist_data'], true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $checklist = [
        'tyres' => $_POST['tyres'] ?? 'no',
        'lights' => $_POST['lights'] ?? 'no',
        'oil' => $_POST['oil'] ?? 'no',
        'brakes' => $_POST['brakes'] ?? 'no',
        'windscreen' => $_POST['windscreen'] ?? 'no',
        'damage' => $_POST['damage'] ?? 'no',
        'leaks' => $_POST['leaks'] ?? 'no'
    ];
    $notes = $_POST['notes'];

    $update_stmt = $pdo->prepare("UPDATE daily_checks SET checklist_data = ?, notes = ? WHERE id = ?");
    $update_stmt->execute([json_encode($checklist), $notes, $check_id]);

    header("Location: reports.php");
    exit();
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Edit Check</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
<h2>Edit Check</h2>
<form method="post" class="row g-3">
  <?php foreach (['tyres','lights','oil','brakes','windscreen','damage','leaks'] as $item): ?>
    <div class="col-md-12">
      <label><input type="checkbox" name="<?= $item ?>" value="yes" <?= ($checklist[$item] ?? 'no') === 'yes' ? 'checked' : '' ?>> <?= ucfirst($item) ?></label>
    </div>
  <?php endforeach; ?>

  <div class="col-md-12">
    <label class="form-label">Notes</label>
    <textarea name="notes" class="form-control"><?= htmlspecialchars($check['notes']) ?></textarea>
  </div>
  <div class="col-md-12">
    <button class="btn btn-primary" type="submit">Save Changes</button>
    <a href="reports.php" class="btn btn-secondary">Cancel</a>
  </div>
</form>
</body>
</html>
